<%-- Copyright (c) Oracle Corporation 2002. All Rights Reserved. --%>

<%--
    NAME
        PhotoAlbum.jsp

    DESCRIPTION
        PhotoAlbum.jsp is one component of a JavaServer Pages application
        that demonstrates the use of interMedia Java Classes for Servlets
        and JSPs by implementing a simple photo album application. This
        page is the entry point to the sample and displays the contents
        of the photo album, including the thumbnail version of each photo.
        Users click on a thumbnail image to view the full-size image. This
        page uses the PhotoAlbumBean JavaBean to access the database.

    NOTES
        See the README.txt file for information on how to build and
        run the demo.
--%>

<%@ page language="java" %>
<%@ page import="imjspdemo.PhotoAlbumBean" %>
<%@ page import="oracle.ord.im.OrdHttpJspResponseHandler" %>
<%@ page import="java.sql.SQLException" %>

<jsp:useBean id="album" scope="page" class="imjspdemo.PhotoAlbumBean"/>
<jsp:useBean id="handler" scope="page"
             class="oracle.ord.im.OrdHttpJspResponseHandler"/>

<%-- HTML header --%>
<html lang="EN">
<head>
<title>Oracle Multimedia JavaServer Pages Photo Album Demo</title>
</head>

<body>

<%-- Page heading --%>
<table border="0" width="100%">
  <tr>
    <td colspan="2" bgcolor="#f7f7e7" align="center"><font size="+2">
      Oracle Multimedia JavaServer Pages Photo Album Demo</font>
    </td>
  </tr>
</table>

<hr size=1>

<%-- Display any error information from a previous attempt --%>
<%
    String errorMessage = request.getParameter( "error" );
    if ( errorMessage != null )
    {
%>
        <p>
        <img src="images/error_qualifier.png" name="errorIcon" alt="Error:"><%= errorMessage %>
        </p>
<%
    }
%>

<%-- get db conn info from request and call setters in PhotoAlbum.java  --%>
<%! String username = null, password = null, connString = null; %>

<%-- do the following only if the reqest comes from PhotoAlbumDBInfo.jsp --%>
<%
    if(request.getParameter("page") != null){
        username = request.getParameter("username");
        password = request.getParameter("password"); 
        connString = request.getParameter("connString");
        if(username == null || username.length()==0){
%>
  <jsp:forward page="PhotoAlbumDBInfo.jsp?error=Please+provide+a+valid+database+username.">
  <jsp:param name="ousername" value='<%= username %>' />
  <jsp:param name="oconnString" value='<%= connString %>' />
  </jsp:forward>
<%
        }
        if(password == null || password.length() ==0){
%>
  <jsp:forward page="PhotoAlbumDBInfo.jsp?error=Please+provide+a+valid+database+password.">
  <jsp:param name="ousername" value='<%= username %>' />
  <jsp:param name="oconnString" value='<%= connString %>' />
  </jsp:forward>
<%
        }
        if(connString == null || connString.length() ==0){
%>
  <jsp:forward page="PhotoAlbumDBInfo.jsp?error=Please+provide+a+valid+database+connection+string.">
  <jsp:param name="ousername" value='<%= username %>' />
  <jsp:param name="oconnString" value='<%= connString %>' />
  </jsp:forward>
<%
        }
        album.setUsername(username.trim()); 
        album.setPassword(password.trim());
        album.setConnString(connString.trim());
    }
%>

   <%-- The first time access to the demo, forward to the db info page. --%>
<%
   if (username == null || password == null || connString == null) 
   {
%>
     <jsp:forward page="PhotoAlbumDBInfo.jsp"/>
<% 
   } 
%>


<%-- Display the thumbnail images in a table; output the table headers. --%>
<p>
<table border="1" cellpadding="3" cellspacing="0" width="100%" 
 summary="Table of thumb nail images">
  <tr bgcolor="#336699">
    <th id="description"><font color="#ffffff">Description</font></th>
    <th id="location"><font color="#ffffff">Location</font></th>
    <th id="image"><font color="#ffffff">Image</font></th>
  </tr>

<%
  //
  // Use a try block to ensure the JDBC connection is released.
  //
  try
  {
    //
    // Select all the rows in the table
    //
    album.selectTable();

    //
    // For each entry...
    //
    int rowCount = 0;
    while ( album.fetch() )
    {
      //
      // Increment row count so we know if there are any entries in the album.
      //
      rowCount++;
%>
      <%-- Display an entry in the album --%>
      <tr>
        <td headers="description">
          <%= PhotoAlbumBean.escapeHtmlString(album.getDescription()) %></td>
<%
        if ( album.getLocation() != null )
        {
            out.print( "<td headers=\"location\">" + 
              PhotoAlbumBean.escapeHtmlString(album.getLocation()) + 
              "</td>" );
        }
        else
        {
            out.print( "<td headers=\"location\">&nbsp;</td>" );
        }
%>
        <td headers="image">
          <a href="PhotoAlbumEntryViewer.jsp?id=<%= album.getId() %>">
<%
        if ( album.getThumb().getContentLength() > 0 )
        {
          //
          // Use thumbnail image for anchor tag.
          //
%>
          <img src=PhotoAlbumMediaViewer.jsp?media=thumb&id=<%= album.getId() %>
               height="<%= album.getThumb().getHeight() %>"
               width="<%=  album.getThumb().getWidth() %>"
               alt="<%=  PhotoAlbumBean.escapeHtmlString(album.getDescription()) %>"
               border=1></a></td></tr>
<%
        }
        else
        {
          //
          // No thumbnail available, use text for anchor tag.
          //
          out.println( "[view media]</a></td></tr>" );
        }
    } // end while ( album.fetch() )
%>

    <%-- Display a message if the album is empty; otherwise, output a
         message telling the user how to view the full-size entry. --%>
    <tr>
      <td scope="col" colspan="3" align="center"><font color="#336699"><b><i>
<%
      if ( rowCount == 0 )
      {
        out.println( "The photo album is empty" );
      }
      else
      {
        out.println( "Select the thumbnail to view the full-size image" );
      }
%>
      </i></b></font></td>
    </tr>
<%! String dbConnErrMsg = null; %>
<%
  } // end try
  catch(SQLException sqle)
  {
    dbConnErrMsg = sqle.getMessage();
    if(dbConnErrMsg.compareTo(album.DB_CONN_FAIL) == 0){
%>
   <jsp:forward page="PhotoAlbumDBInfo.jsp">
   <jsp:param name="error" value='<%= dbConnErrMsg %>' />   
   <jsp:param name="ousername" value='<%= username %>' />
   <jsp:param name="oconnString" value='<%= connString %>' />
   </jsp:forward>
<%    
    }
  }
  finally
  {
    //
    // Ensure the JDBC connection is released
    //
    album.release();
  }
%>

<%-- Finish the table --%>
</table>
</p>

<%-- Output a link to the upload form --%>
<p>
<table width="100%" align="center">
  <tr bgcolor="#f7f7e7">
    <td align="center">
      <a href="PhotoAlbumDBInfo.jsp">Change schema</a>
    </td>
    <td align="center">
      <a href="PhotoAlbumUploadForm.jsp">Upload new photo</a>
    </td>
  </tr>
</table>
</p>

</body>
</html>

